# Copyright 2019-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 050aadd621c6317637938f504090fdf3472a06dd $

EAPI=8

inherit acct-user

DESCRIPTION="File Transfer Protocol (FTP) server user"

IUSE="ftp-at-home"

ACCT_USER_GROUPS=( "ftp" )
ACCT_USER_HOME_OWNER="root:ftp"
ACCT_USER_ID="21"

acct-user_add_deps

pkg_setup() {
	ACCT_USER_HOME="/var/lib/ftp"

	if use ftp-at-home ; then
		ACCT_USER_HOME="/home/ftp"
	fi
}
