# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 5b64d0931d9a407e0b673567fae26b011d07094b $

EAPI=8

inherit autotools flag-o-matic

DESCRIPTION="Completely rewrite of the old system monitoring app procinfo"
HOMEPAGE="https://sourceforge.net/projects/procinfo-ng/"
SRC_URI="https://downloads.sourceforge.net/${PN}/${P}.tar.bz2"

LICENSE="|| ( GPL-2 LGPL-2.1 )"
SLOT="0"
KEYWORDS="amd64 ~hppa x86"

RDEPEND="sys-libs/ncurses:="
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

PATCHES=(
	"${FILESDIR}"/${P}-autotools.patch
	"${FILESDIR}"/${P}-man.patch
	"${FILESDIR}"/${P}-wformat-security.patch
)

src_prepare() {
	default

	mv configure.{in,ac} || die
	eautoreconf
}

src_configure() {
	# bug #719790
	append-cxxflags -std=c++03

	default
}
