# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

MY_PN="${PN^}"
MY_P="${MY_PN}-${PV}"

DESCRIPTION="hash-generation utility that supports the md5, sha1, sha256, sha512, whirlpool, jh-244, jh256, jh-384 and jh-512 hash functions"
HOMEPAGE="https://github.com/ColumPaget/Hashrat"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/ColumPaget/Hashrat.git"
else
	SRC_URI="https://github.com/ColumPaget/${MY_PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi
LICENSE="gpl-3"
SLOT="0"

IUSE="ssl xattr zlib"

RDEPEND="
	dev-libs/libuseful[ssl=,xattr=,zlib=]
	ssl? ( dev-libs/openssl:= )
	zlib? ( sys-libs/zlib:= )
"
DEPEND="${RDEPEND}"

S="${WORKDIR}/${MY_P}"

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	local myeconfargs=(
		--with-system-libuseful
		$(use_enable ssl)
		$(use_enable xattr)
		$(use_enable zlib)
	)
	econf "${myeconfargs[@]}"
}
