# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: c5d3bbe3db5729e45fca6bdd98c9a88feb7bcedb $

EAPI=8
inherit autotools flag-o-matic

DESCRIPTION="Macro recording plugin to G15daemon"
HOMEPAGE="https://gitlab.com/menelkir/g15macro"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://gitlab.com/menelkir/g15macro.git"
else
	SRC_URI="https://gitlab.com/menelkir/${PN}/-/archive/${PV}/${P}.tar.bz2"
	KEYWORDS="~amd64 ~ppc ~ppc64 ~x86"
fi

LICENSE="GPL-2"
SLOT="0"
IUSE=""

DEPEND=">=app-misc/g15daemon-3.0
	>=dev-libs/libg15-3.0
	>=dev-libs/libg15render-3.0
	x11-libs/libX11
	x11-libs/libXtst
"
RDEPEND="${DEPEND}
	sys-libs/zlib
"

PATCHES=(
	"${FILESDIR}/${PN}-1.0.5-autoconf_fixes.patch"
	"${FILESDIR}/${PN}-1.0.5-gcc14.patch"
)

src_prepare() {
	mv configure.{in,ac} || die
	default
	eautoreconf
}

src_configure() {
	# gcc15 "fix"
	append-cflags -Wno-incompatible-pointer-types

	econf --enable-xtest
}
