# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: d70f26ca8510fc008fe31f80ec2f8105cc8a5ab9 $

EAPI=8

PYTHON_COMPAT=( python3_{10..12} )
DISTUTILS_USE_PEP517=setuptools
inherit distutils-r1

DESCRIPTION="Framework for Python apps with simple web frontend"
HOMEPAGE="https://github.com/marcus67/python_base_app"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/marcus67/python_base_app.git"
else
	SRC_URI="https://github.com/marcus67/${PN}/archive/refs/tags/${PV}.tar.gz -> ${P}.gh.tar.gz"
	KEYWORDS="~amd64"
fi
LICENSE=""
SLOT="0"

IUSE=""

RESTRICT="test"

DEPEND="
	${PYTHON_DEPS}
	>=dev-python/coverage-7.3.2[${PYTHON_USEDEP}]
	>=dev-python/flask-2.3.3[${PYTHON_USEDEP}]
	>=dev-python/flask-login-0.6.3[${PYTHON_USEDEP}]
	>=dev-python/flask-wtf-1.2.1[${PYTHON_USEDEP}]
	>=dev-python/jinja22-3.1.2[${PYTHON_USEDEP}]
	dev-python/markupsafe[${PYTHON_USEDEP}]
	>=dev-python/pytest-7.4.2[${PYTHON_USEDEP}]
	>=dev-python/python-dateutil-2.8.2[${PYTHON_USEDEP}]
	>=dev-python/wtforms-3.0.1[${PYTHON_USEDEP}]
"
