# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

LUA_COMPAT=( lua5-1 )
CMAKE_BUILD_TYPE="Release"

inherit cmake desktop lua-single flag-o-matic xdg

DESCRIPTION="Advanced rhythm game, designed for both home and arcade use"
HOMEPAGE="https://www.stepmania.com/"
if [[ "${PV}" == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/stepmania/stepmania.git"
else
	SRC_URI="https://github.com/stepmania/stepmania/archive/v${PV/_beta/-b}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi
LICENSE="MIT CC-BY-NC-4.0"
SLOT="0"
IUSE="alsa crash-handler ffmpeg gles2 +jpeg +gtk jack lto +mp3 networking parport pulseaudio sdl +vorbis +wav xinerama +xrandr"
IUSE+=" cpu_flags_x86_sse2"

REQUIRED_USE="
	${LUA_REQUIRED_USE}
	|| ( alsa pulseaudio jack )
"
RDEPEND="
	${LUA_DEPS}
	dev-libs/jsoncpp
	dev-libs/libpcre:=
	dev-libs/libtomcrypt
	media-libs/glew:=
	media-libs/libglvnd
	media-libs/libpng:=
	sys-libs/zlib
	virtual/glu
	virtual/libiconv
	virtual/libudev
	x11-libs/libX11
	x11-libs/libXext
	x11-libs/libXtst
	alsa? ( media-libs/alsa-lib )
	ffmpeg? ( media-video/ffmpeg:= )
	gtk? (
		dev-libs/glib:2
		x11-libs/gdk-pixbuf:2
		x11-libs/gtk+:3
	)
	jack? ( media-sound/jack-audio-connection-kit )
	jpeg? ( media-libs/libjpeg-turbo:= )
	mp3? ( media-libs/libmad )
	pulseaudio? ( media-libs/libpulse )
	sdl? ( media-libs/libsdl2 )
	vorbis? ( media-libs/libvorbis )
	xinerama? ( x11-libs/libXinerama )
	xrandr? ( x11-libs/libXrandr )
"
DEPEND="
	${RDEPEND}
	app-arch/bzip2
	media-libs/libva
	x11-libs/libICE
	x11-libs/libSM
	ffmpeg? (
		dev-lang/nasm
		dev-lang/yasm
	)
"
BDEPEND="
	virtual/pkgconfig
"

S="${WORKDIR}/${P/_beta/-b}"

PATCHES=(
	"${FILESDIR}/${PN}-ffmpeg-6.patch"
	"${FILESDIR}/${PN}-9999-FHS.patch"
	"${FILESDIR}/${PN}-9999-ffmpeg7.patch"
)

src_configure() {
	# silence "struct std::binary_function’ is deprecated" warning
	append-cxxflags -Wno-deprecated-declarations

	# Minimaid tries to use pre-built static libraries (x86 only, often fails to link)
	# TTY input fails to compile
	local mycmakeargs=(
		-DWITH_ALSA="$(usex alsa)"
		-DWITH_CRASH_HANDLER="$(usex crash-handler)"
		-DWITH_FFMPEG="$(usex ffmpeg)"
		-DWITH_FULL_RELEASE="NO"
		-DWITH_GLES2="$(usex gles2)"
		-DWITH_GPL_LIBS="YES"
		-DWITH_GTK3="$(usex gtk)"
		-DWITH_JACK="$(usex jack)"
		-DWITH_JPEG="$(usex jpeg)"
		-DWITH_LTO="$(usex lto)"
		-DWITH_MINIMAID="NO"
		-DWITH_MP3="$(usex mp3)"
		-DWITH_NETWORKING="$(usex networking)"
		-DWITH_OGG="$(usex vorbis)"
		-DWITH_OSS="NO"
		-DWITH_PARALLEL_PORT="$(usex parport)"
		-DWITH_PROFILING="NO"
		-DWITH_PULSEAUDIO="$(usex pulseaudio)"
		-DWITH_SDL="$(usex sdl)"
		-DWITH_SSE2="$(usex cpu_flags_x86_sse2)"
		-DWITH_SYSTEM_FFMPEG="YES"
		-DWITH_SYSTEM_GLEW="YES"
		-DWITH_SYSTEM_JPEG="YES"
		-DWITH_SYSTEM_JSONCPP="YES"
		-DWITH_SYSTEM_MAD="YES"
		-DWITH_SYSTEM_OGG="YES"
		-DWITH_SYSTEM_PCRE="YES"
		-DWITH_SYSTEM_PNG="YES"
		-DWITH_SYSTEM_TOMCRYPT="YES"
		-DWITH_SYSTEM_TOMMATH="YES"
		-DWITH_SYSTEM_ZLIB="YES"
		-DWITH_TTY="NO"
		-DWITH_WAV="$(usex wav)"
		-DWITH_XINERAMA="$(usex xinerama)"
	)
	cmake_src_configure
}

src_install() {
	cmake_src_install

	dodoc -r Docs/*

	newicon "Themes/default/Graphics/Common window icon.png" "${PN}.png"
	make_desktop_entry "${PN}" StepMania "${PN}" Game
}
