# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit cmake

DESCRIPTION="A cool desktop panel for KDE Plasma 5"
HOMEPAGE="https://dangvd.github.io/ksmoothdock/"
if  [[ ${PV} == 9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/dangvd/ksmoothdock.git"
else
	SRC_URI="https://github.com/dangvd/ksmoothdock/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi
LICENSE="GPL-3"
SLOT="0"

IUSE=""

S="${WORKDIR}/${P}/src"

RDEPEND="
	dev-qt/qtcore:5
	dev-qt/qtdbus:5
	dev-qt/qtgui:5
	dev-qt/qtwidgets:5
	kde-frameworks/kactivities:5
	kde-frameworks/kconfig:5
	kde-frameworks/kcoreaddons:5
	kde-frameworks/kdbusaddons:5
	kde-frameworks/ki18n:5
	kde-frameworks/kxmlgui:5
"

DEPEND="
	${RDEPEND}
	kde-frameworks/kiconthemes:5
	kde-frameworks/kwidgetsaddons:5
	kde-frameworks/kwindowsystem:5
"

src_prepare() {
	cmake_src_prepare

	sed -i '/-Werror/d' CMakeLists.txt || die
}
