# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: e7d9995f840f953c91e1855d8030ec85e8a492af $

EAPI=8

EGIT_BRANCH="frameworks"
inherit cmake kde.org

DESCRIPTION="Plasma Network Monitor"
HOMEPAGE="https://apps.kde.org/de/knemo/"
LICENSE="GPL-2"
IUSE="wifi"
SLOT="0"

if [[ ${KDE_BUILD_TYPE} = release ]]; then
	KEYWORDS="amd64 x86"
	SRC_URI="https://www.gentoofan.org/gentoo/dist/${P}.tar.xz"
fi

DEPEND="
	dev-libs/libnl:3
	dev-qt/qtdbus:5
	dev-qt/qtgui:5
	dev-qt/qtsql:5[sqlite]
	dev-qt/qtwidgets:5
	dev-qt/qtxml:5
	kde-frameworks/kconfig:5
	kde-frameworks/kconfigwidgets:5
	kde-frameworks/kcoreaddons:5
	kde-frameworks/kdbusaddons:5
	kde-frameworks/kdelibs4support:5
	kde-frameworks/kglobalaccel:5
	kde-frameworks/kguiaddons:5
	kde-frameworks/ki18n:5
	kde-frameworks/kio:5
	kde-frameworks/knotifications:5
	kde-frameworks/knotifyconfig:5
	kde-frameworks/kwidgetsaddons:5
	kde-frameworks/kwindowsystem:5
	kde-frameworks/kxmlgui:5
	kde-plasma/libksysguard:5=
	kde-plasma/libplasma:5
	sys-apps/net-tools
	wifi? ( net-wireless/wireless-tools )
"

RDEPEND="${DEPEND}"

PATCHES=(
	"${FILESDIR}/${PN}-0.8.0_pre20161211-frameworks-5630.patch" #697780
)

src_prepare() {
	cmake_src_prepare

	# unused dependency
	sed -e "/KCMUtils/d" -i CMakeLists.txt -i src/kcm/CMakeLists.txt || die
}

src_configure() {
	local mycmakeargs=(
		-DNO_WIRELESS_SUPPORT=$(usex !wifi)
	)

	cmake_src_configure
}
