# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

MY_P="linuxcli_V$(ver_rs 3 '_')"

DESCRIPTION="CLI utility to manage Areca RAID controllers"
HOMEPAGE="https://www.areca.com.tw/support/downloads.html#linux"
SRC_URI="http://www.areca.us/support/s_linux/driver/cli/${MY_P}.zip"
LICENSE=""
SLOT="0"
KEYWORDS="~amd64"
IUSE=""
RDEPEND="${DEPEND}"

RESTRICT="mirror"

S="${WORKDIR}"

src_install() {
	local dir bin

	case ${ARCH} in
		amd64)
			bin="cli64"
		;;
		*)
			die "This arch is not supported."
		;;
	esac

	#dodir /opt/${PN}
	exeinto /opt/${PN}
	doexe "${S}/${bin}"
	dosym ../${PN}/${bin} /opt/bin/areca_cli
}
