# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 4c3ac97819fc49763e7d0a64952841a3145751b0 $

EAPI=8

inherit udev optfeature

DESCRIPTION="Optimize laptop battery life"
HOMEPAGE="https://linrunner.de/tlp/"
SRC_URI="https://github.com/linrunner/TLP/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz"
S="${WORKDIR}/TLP-${PV}"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64"

RDEPEND="
	dev-lang/perl
	virtual/udev
"

src_install() {
	# NOTE(JayF): TLP_WITH_ELOGIND/TLP_WITH_SYSTEMD are both only installing
	#             small init/config files.
	local myemakeargs=(
		DESTDIR="${D}"
		TLP_NO_INIT=1
		TLP_ELOD=/usr/lib/elogind/system-sleep
		TLP_WITH_ELOGIND=1
		TLP_WITH_SYSTEMD=1
		install install-man
	)
	emake "${myemakeargs[@]}"

	fperms 444 /usr/share/tlp/defaults.conf # manpage says this file should not be edited
	newinitd "${FILESDIR}/tlp.init" tlp
	keepdir /var/lib/tlp # created by Makefile, probably important
}

pkg_postinst() {
	udev_reload

	optfeature "disable Wake-on-LAN" sys-apps/ethtool
	optfeature "see disk drive health info in tlp-stat" sys-apps/smartmontools
	optfeature "Sleep hooks" sys-auth/elogind sys-apps/systemd
}

pkg_postrm() {
	udev_reload
}
