# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 7bab15aa055ba5cd3f5547a2132446a1433c9391 $

EAPI=8

inherit cmake kde.org

DESCRIPTION="Widget styles for Qt and GTK2"
HOMEPAGE="https://invent.kde.org/system/qtcurve"

LICENSE="LGPL-2+"
SLOT="0"
IUSE="gtk2 nls plasma qt5 +qt6 test X"

if [[ ${KDE_BUILD_TYPE} = release ]] ; then
	SRC_URI="https://github.com/KDE/qtcurve/archive/${PV/_/-}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~hppa ~ppc ~ppc64 ~sparc ~x86"
	S="${WORKDIR}/${P/_/-}"
fi

REQUIRED_USE="gtk2? ( X )
	|| ( gtk2 qt5 qt6 )
	plasma? ( qt6 )
"
RESTRICT="test"

DEPEND="
	gtk2? ( x11-libs/gtk+:2 )
	plasma? (
		kde-frameworks/frameworkintegration:6
		kde-frameworks/karchive:6
		kde-frameworks/kcolorscheme:6
		kde-frameworks/kcompletion:6
		kde-frameworks/kconfig:6
		kde-frameworks/kconfigwidgets:6
		kde-frameworks/kcoreaddons:6
		kde-frameworks/kguiaddons:6
		kde-frameworks/ki18n:6
		kde-frameworks/kiconthemes:6
		kde-frameworks/kio:6
		kde-frameworks/kwidgetsaddons:6
		kde-frameworks/kwindowsystem:6
		kde-frameworks/kxmlgui:6
	)
	qt5? (
		dev-qt/qtcore:5
		dev-qt/qtdbus:5
		dev-qt/qtgui:5
		dev-qt/qtsvg:5
		dev-qt/qtwidgets:5
		X? ( dev-qt/qtx11extras:5 )
	)
	qt6? (
		dev-qt/qtbase:6[dbus,gui,widgets]
		dev-qt/qtsvg:6
		X? ( dev-qt/qtbase:6=[X] )
	)
	X? (
		x11-libs/libX11
		x11-libs/libxcb
	)
"
RDEPEND="${DEPEND}"
BDEPEND="
	virtual/pkgconfig
	nls? ( sys-devel/gettext )
	plasma? ( kde-frameworks/extra-cmake-modules:0 )
"

DOCS=( AUTHORS ChangeLog.md README.md TODO.md )

src_configure() {
	local mycmakeargs=(
		-DBUILD_TESTING="$(usex test)"
		-DENABLE_GTK2="$(usex gtk2)"
		-DENABLE_QT4=OFF
		-DENABLE_QT5="$(usex qt5)"
		-DENABLE_QT6="$(usex qt6)"
		-DLIB_INSTALL_DIR="$(get_libdir)"
		-DQTC_ENABLE_X11="$(usex X)"
		-DQTC_INSTALL_PO="$(usex nls)"
		-DQTC_KDE4_DEFAULT_HOME=ON
		-DQTC_QT4_ENABLE_KDE=OFF
		-DQTC_QT5_ENABLE_KDE=OFF
		-DQTC_QT6_ENABLE_KDE="$(usex plasma)"
	)
	cmake_src_configure
}
