# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: d70f26ca8510fc008fe31f80ec2f8105cc8a5ab9 $

EAPI=8

PYTHON_COMPAT=( python3_{10..12} )
DISTUTILS_USE_PEP517=setuptools
inherit distutils-r1

DESCRIPTION="Parental Control Application implemented in Python 3"
HOMEPAGE="https://github.com/marcus67/little_brother"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/marcus67/little_brother.git"
else
	SRC_URI="https://github.com/marcus67/${PN}/archive/refs/tags/${PV}.tar.gz -> ${P}.gh.tar.gz"
	KEYWORDS="~amd64"
fi
LICENSE="GPL-3"
SLOT="0"

IUSE=""

RESTRICT="test"

RDEPEND="
	${PYTHON_DEPS}
	dev-db/sqlite
	dev-java/mockito
	>=dev-python/alembic-1.11.1[${PYTHON_USEDEP}]
	>=dev-python/distro-1.8.0[${PYTHON_USEDEP}]
	>=dev-python/flask-2.3.2[${PYTHON_USEDEP}]
	>=dev-python/flask-babel-3.1.0[${PYTHON_USEDEP}]
	>=dev-python/flask-login-0.6.2[${PYTHON_USEDEP}]
	>=dev-python/flask-migrate-4.0.4[${PYTHON_USEDEP}]
	>=dev-python/flask-wtf-1.1.1[${PYTHON_USEDEP}]
	>=dev-python/humanize-4.7.0[${PYTHON_USEDEP}]
	>=dev-python/packaging-23.1[${PYTHON_USEDEP}]
	>=dev-python/prometheus-client-0.17.1[${PYTHON_USEDEP}]
	>=dev-python/psutil-5.9.5[${PYTHON_USEDEP}]
	>=dev-python/pymysql-1.1.0[${PYTHON_USEDEP}]
	>=dev-python/pytest-7.4.0[${PYTHON_USEDEP}]
	dev-python/python_base_app[${PYTHON_USEDEP}]
	>=dev-python/python-dateutil-2.8.2[${PYTHON_USEDEP}]
	>=dev-python/requests-2.31.0[${PYTHON_USEDEP}]
	>=dev-python/secure-0.3.0[${PYTHON_USEDEP}]
	>=dev-python/selenium-4.10.0[${PYTHON_USEDEP}]
	>=dev-python/sqlalchemy-2.0.19[${PYTHON_USEDEP}]
	>=dev-python/urllib3-2.0.4[${PYTHON_USEDEP}]
	>=dev-python/wtforms-3.0.1[${PYTHON_USEDEP}]
"
