# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7
inherit sgml-catalog-r1 poly-c_ebuilds

DOCBOOKDIR="/usr/share/sgml/${PN/-//}"
REAL_P="${PN/5-xml}-${MY_PV}"
DESCRIPTION="Docbook DTD for XML"
HOMEPAGE="https://docbook.org/"
SRC_URI="https://docbook.org/xml/${MY_PV}/${REAL_P}.zip"

LICENSE="docbook"
SLOT="$(ver_cut 1-2 ${MY_PV})"
KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~hppa ~loong ~m68k ~mips ~ppc ~ppc64 ~riscv ~s390 ~sparc ~x86 ~amd64-linux ~x86-linux ~arm64-macos ~ppc-macos ~x64-macos ~x64-solaris"
IUSE=""

RDEPEND="app-text/docbook-xsl-ns-stylesheets"
DEPEND=">=app-arch/unzip-5.41"
BDEPEND="dev-libs/libxml2"

S="${WORKDIR}/${REAL_P}"

src_compile() {
	local ver="$(ver_cut 1-2 ${MY_PV})"
	local catalog="${PN/5-xml}-${ver}"
	local xmlcat='xmlcatalog --noout'

	${xmlcat} --create ${catalog} || die

	${xmlcat} --add "public" "-//OASIS//DTD DocBook XML ${ver}//EN" \
		"file://${DOCBOOKDIR}/"
}

src_install() {
	keepdir /etc/xml

	insinto "/usr/share/sgml/docbook/xml-dtd-${MY_PV}"
	doins *.cat *.dtd *.mod *.xml
	insinto "/usr/share/sgml/docbook/xml-dtd-${MY_PV}/ent"
	doins ent/*.ent

	insinto /etc/sgml
	newins - "xml-docbook-${MY_PV}.cat" <<-EOF
		CATALOG "${EPREFIX}/etc/sgml/sgml-docbook.cat"
		CATALOG "${EPREFIX}/usr/share/sgml/docbook/xml-dtd-${MY_PV}/docbook.cat"
	EOF

	cp ent/README README.ent
	dodoc ChangeLog README*
}

pkg_preinst() {
	# work-around old revision removing it
	cp "${ED}"/etc/sgml/xml-docbook-${MY_PV}.cat "${T}" || die
}

pkg_postinst() {
	local backup=${T}/xml-docbook-${MY_PV}.cat
	local real=${EROOT}/etc/sgml/xml-docbook-${MY_PV}.cat

	if ! cmp -s "${backup}" "${real}"; then
		cp "${backup}" "${real}" || die
	fi

	# See bug #816303 for rationale behind die
	build-docbook-catalog || die "Failed to regenerate docbook catalog. Is /run mounted?"
	sgml-catalog-r1_pkg_postinst
}

pkg_postrm() {
	# See bug #816303 for rationale behind die
	build-docbook-catalog || die "Failed to regenerate docbook catalog. Is /run mounted?"
	sgml-catalog-r1_pkg_postrm
}
