# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit poly-c_ebuilds

if [[ ${MY_PV} == *9999 ]]; then
	inherit autotools git-r3
	EGIT_REPO_URI="https://gitlab.com/menelkir/libg15.git"
else
	KEYWORDS="~amd64 ~ppc ~ppc64 ~x86"
	SRC_URI="https://gitlab.com/menelkir/${PN}/-/archive/${MY_PV}/${MY_P}.tar.bz2"
fi

DESCRIPTION="The libg15 library gives low-level access to the Logitech G15 keyboard"
HOMEPAGE="https://gitlab.com/menelkir/libg15"

LICENSE="GPL-2"
SLOT="0"

RDEPEND="virtual/libusb:0"
DEPEND="${RDEPEND}"

src_prepare() {
	default
	[[ ${MY_PV} == *9999 ]] && eautoreconf
}

src_configure() {
	econf --disable-static
}

src_install() {
	default

	# no static archives
	find "${ED}" -type f -name '*.la' -delete || die
}
