# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit flag-o-matic meson

DESCRIPTION="Pidgin's GLib Ncurses Toolkit"
HOMEPAGE="https://keep.imfreedom.org/libgnt/libgnt"
if [[ "${PV}" == *9999 ]] ; then
	inherit mercurial
	EHG_REPO_URI="https://keep.imfreedom.org/libgnt/libgnt/"
else
	SRC_URI="mirror://sourceforge/pidgin/${P}.tar.xz"
	KEYWORDS="~alpha amd64 arm arm64 ~loong ppc ppc64 ~riscv ~sparc x86 ~amd64-linux ~x86-linux"
fi
LICENSE="GPL-2"
SLOT="0"

IUSE="doc"

RDEPEND="
	!<net-im/pidgin-2.14.0
	dev-libs/glib:2
	dev-libs/libxml2:=
	sys-libs/ncurses:0=
"
DEPEND="${RDEPEND}"
BDEPEND="
	dev-util/glib-utils
	virtual/pkgconfig
	doc? ( dev-util/gtk-doc )
"

src_configure() {
	# -Werror=lto-type-mismatch
	# https://bugs.gentoo.org/855872
	# https://issues.imfreedom.org/issue/LIBGNT-19/Build-fails-with-LTO
	filter-lto

	local emesonargs=(
		$(meson_use doc)
	)
	meson_src_configure
}
