# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

MY_PN='libUseful'
MY_P="${MY_PN}-${PV}"

DESCRIPTION="range of functions that simplify common programming tasks in C"
HOMEPAGE="https://github.com/ColumPaget/libUseful"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/ColumPaget/libUseful.git"
else
	SRC_URI="https://github.com/ColumPaget/${MY_PN}/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi
LICENSE=""
SLOT="0"

IUSE_CPU_FLAGS="cpu_flags_x86_mmx cpu_flags_x86_sse cpu_flags_x86_sse2"
IUSE="caps ipv6 seccomp ssl xattr zlib ${IUSE_CPU_FLAGS}"

S="${WORKDIR}/${MY_P}"

PATCHES=(
	"${FILESDIR}/${PN}-5.45-autotools_improvements.patch"
)

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	local cpu_flag
	if use cpu_flags_x86_sse2 ; then
		cpu_flag=sse2
	elif use cpu_flags_x86_sse ; then
		cpu_flag=sse
	elif use cpu_flags_x86_mmx ; then
		cpu_flag=mmx
	else
		cpu_flag=no
	fi

	local myeconfargs=(
		--enable-simd="${cpu_flag}"
		$(use_enable caps capabilities)
		$(use_enable ipv6 ip6)
		$(use_enable seccomp)
		$(use_enable ssl)
		$(use_enable xattr)
		$(use_enable zlib)
	)
	econf "${myeconfargs[@]}"
}
