# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit cmake unpacker xdg

DESCRIPTION="Wolfenstein: Enemy Territory 2.60b compatible client/server"
HOMEPAGE="http://www.etlegacy.com/"

# We need the game files from the original enemy-territory release
ET_RELEASE='et260b'
ET_GAME_URI="https://cdn.splashdamage.com/downloads/games/wet/${ET_RELEASE}.x86_full.zip"
ETL_MOD_NUM='698'
ETL_MOD_URI="https://www.etlegacy.com/download/file/${ETL_MOD_NUM} -> ${PN}-mod-v${PV}.zip"

SRC_URI="
	${ET_GAME_URI}
	${ETL_MOD_URI}
"

if [[ ${PV} = "9999" ]]; then
	inherit git-r3
	EGIT_REPO_URI="git://github.com/${PN}/${PN}.git"
else
	SRC_URI+=" https://github.com/${PN}/${PN}/archive/v${PV/_rc/rc}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi

LICENSE="GPL-3 RTCW-ETEULA"
SLOT="0"
IUSE="+autoupdate +curl dedicated +freetype +gettext ipv6 irc lua omnibot +openal +opengl +png renderer2 renderer-gles sqlite +ssl +theora +vorbis vulkan"
#REQUIRED_USE="omnibot? ( x86 )"

RESTRICT="mirror"

# TODO add debug use for CMAKE_BUILD_TYPE=debug

if [[ ${PV} == "9999" ]]; then
	LUADEPEND="lua? ( dev-lang/lua:5.2 )"
else
	LUADEPEND="lua? ( >=dev-lang/lua-5.1 )"
fi

UIDEPEND="
	>=media-libs/glew-1.10.0
	media-libs/libsdl2[sound,video,X]
	virtual/jpeg:0
	virtual/opengl
	sys-libs/zlib:=[minizip]
	curl? ( net-misc/curl )
	freetype? ( media-libs/freetype )
	gettext? ( sys-devel/gettext )
	renderer-gles? ( media-libs/mesa[gles1] )
	openal? ( media-libs/openal )
	png? ( media-libs/libpng:0= )
	sqlite? ( dev-db/sqlite )
	ssl? ( dev-libs/openssl:0= )
	theora? ( media-libs/libtheora:= )
	vorbis? ( media-libs/libvorbis )
	${LUADEPEND}
"

DEPEND="
	!games-fps/etlegacy-bin
	dev-libs/cJSON
	dev-libs/openssl:=
	opengl? ( ${UIDEPEND} )
"
#	!dedicated? ( ${UIDEPEND} )"

RDEPEND="${DEPEND}"

#QA_TEXTRELS="usr/share/games/etlegacy/legacy/omni-bot/omnibot_et.so"

S="${WORKDIR}/${P/_rc/rc}"

PATCHES=(
	"${FILESDIR}"/${PN}-2.81.0-fix_build_against_system_sqlite.patch
)

src_unpack() {
	if [[ "${PV}" = 9999 ]] ; then
		git-r3_src_unpack
	else
		default
	fi
	mkdir et && cd et || die
	unzip "${DISTDIR}"/${ET_RELEASE}.x86_full.zip
	unpack_makeself ${ET_RELEASE}.x86_keygen_V03.run
}

src_prepare() {
	cmake_src_prepare
	#if [[ "${PV}" != 9999 ]] ; then
	#	sed -e "/^set(ETLEGACY_VERSION_MINOR/s@[[:digit:]]\+@$(ver_cut 2)@" \
	#		-i cmake/ETLVersion.cmake || die
	#fi
	sed -i -e 's@\(${ETLEGACY_VERSION_MINOR}\)[_-]dirty@\1@' cmake/ETLVersion.cmake || die
	#sed -i -e 's@\(${ETLEGACY_VERSION_MINOR}\)[_-]dirty@\1.${ETLEGACY_VERSION_PATCH}@' cmake/ETLVersion.cmake || die
}

src_configure() {
	mycmakeargs=(
		-DDOCDIR="/usr/share/doc/${PF}"
		# path and build type
		-DCMAKE_BUILD_TYPE="Release"
		-DCMAKE_INSTALL_PREFIX="${EPREFIX}/usr"
		-DINSTALL_DEFAULT_BASEDIR="${EPREFIX}/usr/share/${PN}"
		-DINSTALL_DEFAULT_BINDIR="${EPREFIX}/usr/bin"
		-DINSTALL_DEFAULT_MODDIR="${EPREFIX}/usr/share/${PN}"
		-DCMAKE_LIBRARY_PATH="${EPREFIX}/usr/$(get_libdir)"
		-DCMAKE_INCLUDE_PATH="${EPREFIX}/usr/include"
		-DCROSS_COMPILE32="0"
		# what to build
		-DBUILD_CLIENT="$(usex opengl)"
		-DBUILD_CLIENT_MOD="$(usex opengl)"
		-DBUILD_MOD="ON"
		-DBUILD_MOD_PK3="ON"
		-DBUILD_SERVER="$(usex dedicated)"
		-DBUILD_SERVER_MOD="$(usex dedicated)"
		# no bundled libs
		-DBUNDLED_LIBS="0"
		-DBUNDLED_LIBS_DEFAULT="0"
		#-DBUNDLED_SDL="0"
		#-DBUNDLED_CURL="0"
		#-DBUNDLED_JPEG="0"
		#-DBUNDLED_LUA="0"
		#-DBUNDLED_OGG_VORBIS="0"
		#-DBUNDLED_GLEW="0"
		#-DBUNDLED_FREETYPE="0"
		-DBUNDLED_SQLITE3="0"
		# features
		-DFEATURE_CURL="$(usex curl)"
		-DFEATURE_SSL="$(usex ssl)"
		-DFEATURE_OGG_VORBIS="$(usex vorbis)"
		-DFEATURE_THEORA="$(usex theora)"
		-DFEATURE_OPENAL="$(usex openal)"
		-DFEATURE_FREETYPE="$(usex freetype)"
		-DFEATURE_PNG="$(usex png)"
		-DFEATURE_LUA="$(usex lua)"
		-DFEATURE_IRC_CLIENT="$(usex irc)"
		-DFEATURE_IPV6="$(usex ipv6)"
		-DFEATURE_GETTEXT="$(usex gettext)"
		-DFEATURE_DBMS="$(usex sqlite)"
		-DFEATURE_LUASQL="$(usex lua "$(usex sqlite)" OFF)"
		-DFEATURE_ANTICHEAT="1"
		-DFEATURE_AUTOUPDATE="$(usex autoupdate)"
		# renderers
		-DFEATURE_RENDERER2="$(usex renderer2)"
		-DFEATURE_RENDERER_GLES="$(usex renderer-gles)"
		-DFEATURE_RENDERER_VULKAN="$(usex vulkan)"

		-DENABLE_MULTI_BUILD="OFF"

		-DFEATURE_OMNIBOT="$(usex omnibot)"
		-DINSTALL_OMNIBOT="$(usex omnibot)"
		-DINSTALL_GEOIP="0"
		-DINSTALL_WOLFADMIN="0"

		# Where to find original et-2.60b files
		-DET_FS_BASEPATH="${WORKDIR}/et"
		-DET_KEY="OFF"
		
	)

	cmake_src_configure
}

src_install() {
	cmake_src_install

	local arch="$(uname -m)"
	local inst_dir="/usr/share/${PN}"

	if use opengl ; then
		insinto /usr/share/etlegacy/legacy
		doins ${BUILD_DIR}/legacy/ui.mp.${arch}.so
	fi

	# Install the game files
	#insinto ${inst_dir}/etmain
	#doins "${WORKDIR}"/et/etmain/pak[012].pk3
	#insinto ${inst_dir}/etmain/video
	#doins "${WORKDIR}"/et/etmain/video/etintro.roq

	# Install official mod pack
	insinto ${inst_dir}/legacy
	doins "${WORKDIR}"/legacy_v${PV}.pk3
}
