# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 00f32e5f7b4b2d489db6a286591c691e61ff8a17 $

EAPI=8

LUA_COMPAT=( lua5-{1..4} luajit )

inherit desktop flag-o-matic lua-single xdg cmake

if [[ ${PV} == *9999 ]] ; then
	EGIT_REPO_URI="https://github.com/CelestiaProject/Celestia.git"
	inherit git-r3
else
	if [[ ${PV} == *_p* ]] ; then
		COMMIT_ID="9292455b420aa865482078c3149ae974367270e5"
		SRC_URI="https://github.com/${PN^}Project/${PN^}/archive/${COMMIT_ID}.tar.gz -> ${P}.tar.gz"
		S="${WORKDIR}/${PN^}-${COMMIT_ID}"
		KEYWORDS="~amd64 ~x86"
	else
		SRC_URI="https://github.com/${PN^}Project/${PN^}/archive/${PV/_/-}.tar.gz -> ${P}.tar.gz"
	fi
fi

DESCRIPTION="OpenGL 3D space simulator"
HOMEPAGE="https://celestiaproject.space https://github.com/CelestiaProject/Celestia"

LICENSE="GPL-2+"
SLOT="0"
IUSE="ffmpeg lto lua nls +qt6 sdl"
REQUIRED_USE="
	|| ( qt6 sdl )
	lua? ( ${LUA_REQUIRED_USE} )
"

BDEPEND="
	dev-cpp/eigen
	virtual/pkgconfig
	nls? (
		sys-devel/gettext
		virtual/libintl
	)
"
DEPEND="
	dev-libs/libfmt:=
	media-libs/freetype
	media-libs/glew:0=
	media-libs/libepoxy
	media-libs/libglvnd
	media-libs/libjpeg-turbo:0=
	media-libs/libpng:0=
	sys-libs/zlib:=
	virtual/glu
	virtual/opengl
	ffmpeg? ( media-video/ffmpeg:= )
	lua? ( ${LUA_DEPS} )
	qt6? ( dev-qt/qtbase:6[gui,opengl,widgets] )
	sdl? ( media-libs/libsdl2[X] )
"
RDEPEND="${DEPEND}"

PDEPEND="~sci-astronomy/celestiacontent-9999[nls?]"

PATCHES=(
	# add a ~/.celestia for extra directories
	#"${FILESDIR}"/${PN}-1.6.99-cfg.patch
	# allow forcing CMake to look for a specific Lua version instead of the newest branch installed
	"${FILESDIR}"/${PN}-1.7.0-cmake_lua_version.patch
)

src_prepare() {
	cmake_src_prepare
}

src_configure() {
	local mycmakeargs=(
		-DCELCFG_EXTRAS_DIRS='"~/.celestia"'
		-DENABLE_CELX="$(usex lua)"
		-DENABLE_NLS="$(usex nls)"
		-DENABLE_FFMPEG="$(usex ffmpeg)"
		-DENABLE_QT5=OFF
		-DENABLE_QT6="$(usex qt6)"
		-DENABLE_TOOLS=ON
		-DENABLE_WIN=OFF
	)
	# Upstream always looks for LuaJIT first unless stopped, and we only need
	# the version specification when linking against PUC Lua
	if use lua && ! use lua_single_target_luajit ; then
		mycmakeargs+=(
			-DCMAKE_DISABLE_FIND_PACKAGE_LuaJIT=ON
			-DLUA_VERSION=$(lua_get_version)
		)
	fi
	cmake_src_configure
}

src_install() {
	cmake_src_install

	# Icons with more resolutions
	doicon -s 48 "${FILESDIR}"/${PN}.png
	doicon -s 128 "${S}"/src/celestia/qt/data/${PN}.png
	doicon -s scalable "${FILESDIR}"/${PN}.svg

	dodoc AUTHORS README TRANSLATORS *.txt
}
