# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

SDIR='sp157501-158000'
TARBALL='sp157762.tgz'

DESCRIPTION="HP Flash and Replicated Setup Utilities"
HOMEPAGE="https://ftp.hp.com/pub/caps-softpaq/cmit/linuxtools/HP_LinuxTools.html"
SRC_URI="https://ftp.hp.com/pub/softpaq/${SDIR}/${TARBALL}"
LICENSE="AS-IS"
SLOT="0"

KEYWORDS="~amd64"
IUSE=""
RESTRICT="strip"

RDEPEND="~sys-kernel/hpuefi-mod-3.06"

S="${WORKDIR}/${P}_x86_64"

src_unpack() {
	unpack ${A}
	unpack non-rpms/${P}_x86_64.tgz
}

src_prepare() {
	default

	sed -i \
		-e 's@/lib/modules/`uname -r`/kernel/drivers/hpuefi/\(mkdevhpuefi\)@/opt/hp/hp-flash/\1@g' \
		hp-{flash,repsetup} || die
}

src_install() {
	local DOCS=(
		#"${WORKDIR}"/${P/-}/docs/"HP Linux Tools Readme".*
		${S}/docs/hp-{flash,repsetup}-README
	)

	local ins_base="/opt/hp/${PN}"
	exeinto ${ins_base}
	doexe hp-{flash,repsetup}
	# Use the rh90 binaries
	exeinto ${ins_base}/bin
	newexe builds/hp-flash.rh90 hp-flash
	newexe builds/hp-repsetup.rh90 hp-repsetup

	einstalldocs
	docompress -x /usr/share/doc/${PF}/"HP Linux Tools Readme.rtf"
}
