# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 1abbccdd78c290bcb994af90ad03de0a678e64de $

EAPI=8

inherit flag-o-matic gkrellm-plugin multilib

DESCRIPTION="GKrellm plugin for monitoring bluetooth (Linux BlueZ) adapters"
HOMEPAGE="http://gkrellm-bluez.sourceforge.net"
SRC_URI="https://downloads.sourceforge.net/gkrellm-bluez/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 x86"

RDEPEND="
	app-admin/gkrellm:2[X]
	net-wireless/bluez
"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}"/${P}-notheme.patch
)

PLUGIN_DOCS=( THEMING NEWS )

src_prepare() {
	default

	# Be a bit more future proof, bug #260948
	sed "s/-Werror//" -i src/Makefile.am src/Makefile.in || die
}

src_configure() {
	# gcc15 "fix"
	append-cflags -Wno-incompatible-pointer-types

	PLUGIN_SO=( src/.libs/gkrellmbluez$(get_modname) )

	default
}
