# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: c7ab54a56949ea32af8f39b0fbb12715da0a2601 $

EAPI=8

inherit autotools

DESCRIPTION="A program for interoperability with Active Directory"
HOMEPAGE="https://github.com/msktutil/msktutil"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/msktutil/msktutil.git"
else
	SRC_URI="https://github.com/${PN}/${PN}/releases/download/${PV}/${P}.tar.bz2"
	KEYWORDS="~amd64 ~x86"
fi
LICENSE=""
SLOT="0"

IUSE="udns"

RDEPEND="
	net-nds/openldap
	sys-fs/e2fsprogs
	virtual/krb5
	udns? ( net-libs/udns )
"
DEPEND="${RDEPEND}"

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	local myeconfargs=(
		$(use_with udns)
	)
	econf "${myeconfargs[@]}"
}
