# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id $

EAPI=8

inherit autotools

DESCRIPTION="sudosh is a sudo shell, filter and can be used as a login shell"
HOMEPAGE="https://github.com/squash/sudosh2"
SRC_URI="https://github.com/squash/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE=""
RDEPEND=""
DEPENDS="virtual/logger"

PATCHES=(
	"${FILESDIR}/${PN}-1.0.5-makefile.patch"
)

src_prepare() {
	default
	mv configure.{in,ac} || die
	sed '/-Werror/d' -i configure.ac || die
	eautoreconf
}

#src_configure() {
#	econf --with-defshell
#}

pkg_postinst() {
	if [[ -z ${REPLACING_VERSIONS} ]]; then
		einfo "Configure sudosh to be used with sudo"
		einfo "====================================="
		einfo "1) configure /etc/sudoers to allow system administrators to execute"
		einfo "/usr/bin/sudosh"
		einfo ""
		einfo "Example entry to /etc/sudoers:"
		einfo ""
		einfo "-- /etc/sudoers begin --"
		einfo "User_Alias      ADMINS=admin1,admin2,admin3"
		einfo "User_Alias      DBAS=dba1,dba2,dba3"
		einfo "Cmnd_Alias      SUDOSH=/usr/bin/sudosh"
		einfo ""
		einfo "ADMINS          ALL=SUDOSH"
		einfo "DBAS            ALL=(oracle)/usr/bin/sudosh"
		einfo ""
		einfo "-- /etc/sudoers end --"
	fi
			
	if ! grep -q '^/usr/bin/sudosh$' "${EROOT}"/etc/shells ; then
		einfo "Updating /etc/shells"
		echo "/usr/bin/sudosh" >> "${EROOT}"/etc/shells \
			|| eerror "Failed to update /etc/shells"
	fi
}

pkg_postrm() {
	if grep -q '^/usr/bin/sudosh$' "${EROOT}"/etc/shells ; then
		einfo "Updating /etc/shells"
		sed '/^/usr/bin/sudosh$/d' -i "${EROOT}"/etc/shells \
			|| eerror "Failed to update /etc/shells"
	fi
}
