# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit desktop unpacker

MY_P="${PN^}-${PV}"

DESCRIPTION=""
HOMEPAGE=""
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI=""
else
	SRC_URI="https://download.breitbandmessung.de/bbm/${MY_P}-linux.deb"
	KEYWORDS="~amd64"
fi
LICENSE="AGPL-3"
SLOT="0"

IUSE=""

RDEPEND="
	app-accessibility/at-spi2-core:2
	dev-libs/expat
	dev-libs/glib:2
	dev-libs/nspr
	dev-libs/nss
	media-libs/alsa-lib
	media-libs/mesa
	net-print/cups
	sys-apps/dbus
	virtual/libudev
	x11-libs/cairo
	x11-libs/gtk+:3
	x11-libs/libX11
	x11-libs/libXcomposite
	x11-libs/libXdamage
	x11-libs/libXext
	x11-libs/libXfixes
	x11-libs/libXrandr
	x11-libs/libdrm
	x11-libs/libxcb
"

S="${WORKDIR}"

src_unpack() {
	unpack_deb "${A}"
}

src_install() {
	cp -a ${WORKDIR}/opt "${ED}" || die

	domenu "${S}"/usr/share/applications/${PN}.desktop

	local size
	for size in 48 64 96 128 256 512 1024 ; do
		#pushd  &>/dev/null || die
		doicon -s ${size} "${S}"/usr/share/icons/hicolor/${size}x${size}/apps/${PN}.png
		#popd &>/dev/null
	done
}
