# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: de6a0fbffcfc66ee0f88be44b7de1e0d7da09a75 $

EAPI=8

CMAKE_QA_COMPAT_SKIP=1
inherit cmake xdg

MY_PV="${PV/_rc/-rc.}"
MY_P="SuperTux-v${MY_PV}-Source"

DESCRIPTION="A game similar to Super Mario Bros"
HOMEPAGE="https://www.supertux.org"
SRC_URI="https://github.com/SuperTux/${PN}/releases/download/v${MY_PV}/${MY_P}.tar.gz"
S="${WORKDIR}/${MY_P}"

LICENSE="GPL-2+ GPL-3+ ZLIB MIT CC-BY-SA-2.0 CC-BY-SA-3.0"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~x86"
IUSE="debug test"
RESTRICT="!test? ( test )"

# =media-libs/libsdl2-2.0.14-r0 can cause supertux binary to move entire
# content of ${HOME} to ${HOME}/.local/share/supertux2/
# DO NOT REMOVE THIS BLOCKER!!! See bug #764959
RDEPEND="
	!=media-libs/libsdl2-2.0.14-r0
	>=dev-games/physfs-3.0
	dev-libs/boost:=[nls]
	media-libs/freetype
	media-libs/glew:=
	media-libs/libpng:0=
	>=media-libs/libsdl2-2.0.1[joystick,video]
	media-libs/libvorbis
	media-libs/openal
	>=media-libs/sdl2-image-2.0.0[png,jpeg]
	>=net-misc/curl-7.21.7
	virtual/opengl
"
DEPEND="${RDEPEND}
	media-libs/glm"
BDEPEND="
	virtual/pkgconfig
	test? ( dev-cpp/gtest )
"

PATCHES=(
	"${FILESDIR}"/${PN}-0.5.0-tinygettext.patch
	"${FILESDIR}"/${PN}-0.6.0-{license,icon,obstack}.patch
	"${FILESDIR}"/${PN}-0.6.3-missing-include.patch
	"${FILESDIR}"/${PN}-0.6.3-squirrel-CVE-2021-41556.patch
	"${FILESDIR}"/${PN}-0.6.3-squirrel-CVE-2022-30292.patch
	"${FILESDIR}"/${PN}-0.6.3-cmake4.patch
	"${FILESDIR}"/${PN}-0.6.3-boost189.patch
)

src_configure() {
	local mycmakeargs=(
		-DWERROR=OFF
		-DINSTALL_SUBDIR_BIN=bin
		-DINSTALL_SUBDIR_DOC=share/doc/${PF}
		-DINSTALL_SUBDIR_SHARE=share/${PN}2
		-DENABLE_SQDBG="$(usex debug)"
		-DUSE_SYSTEM_PHYSFS=ON
		-DIS_SUPERTUX_RELEASE=ON
		-DBUILD_TESTS="$(usex test)"
	)
	cmake_src_configure
}

src_test() {
	# Assumes in-source build to find test data
	local -x GTEST_FILTER="-IFileStreamTest.test"
	cmake_src_test
}
