# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="GTK UI that allows to configure the Akai MPK mini III MIDI keyboard"
HOMEPAGE="https://github.com/tsmetana/mpk3-settings"
if [[ "${PV}" == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/tsmetana/${PN}.git"
else
	SRC_URI="https://github.com/tsmetana/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64"
fi
LICENSE="GPL-3"
SLOT="0"
IUSE=""

RDEPEND="
	dev-libs/glib:2
	>=media-libs/rtmidi-5.0.0:=
	x11-libs/gtk+:3
"
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

src_prepare() {
	default
	eautoreconf
}
