# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

GUILE_COMPAT=( 2-2 )

inherit guile-single meson xdg-utils gnome2-utils

DESCRIPTION="Zrythm is a digital audio workstation designed to be featureful and easy to use."
HOMEPAGE="https://www.zrythm.org/"

if [[ ${PV} != *9999* ]] ; then
	#SRC_URI="https://git.zrythm.org/cgit/zrythm/snapshot/${P}.tar.gz"
	SRC_URI="https://github.com/${PN}/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64"
else
	inherit git-r3
	#EGIT_REPO_URI="https://git.zrythm.org/git/zrythm"
	EGIT_REPO_URI="https://github.com/zrythm/zrythm.git"
fi

LICENSE="GPL-3"
SLOT="0"

	#dev-libs/libcyaml
	#>=dev-libs/reproc-14.1.0
	#kde-frameworks/breeze-icons
	#>=media-libs/libaudec-0.2.3
RDEPEND="
	${GUILE_DEPS}
	app-arch/zstd
	$(guile_gen_cond_dep '
		dev-scheme/guile-libyaml[${GUILE_MULTI_USEDEP}]
	')
	media-libs/lilv
	media-libs/chromaprint
	media-libs/rubberband
	sci-libs/fftw:*[threads]
	x11-libs/gtk+:3
	x11-libs/gtksourceview:=
"
DEPEND="
	${RDEPEND}
"
#BDEPEND="
#	>=dev-util/meson-0.55.0
#"

REQUIRED_USE="${GUILE_REQUIRED_USE}"

#src_install() {
#	DESTDIR="${D}" eninja -C "${BUILD_DIR}" install
#}

pkg_postinst() {
	xdg_mimeinfo_database_update
	xdg_desktop_database_update
	xdg_icon_cache_update
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_mimeinfo_database_update
	xdg_desktop_database_update
	xdg_icon_cache_update
	gnome2_schemas_update
}
