# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools poly-c_ebuilds

DESCRIPTION="A grep for network layers"
HOMEPAGE="https://github.com/jpr5/ngrep"
SRC_URI="https://github.com/jpr5/ngrep/archive/refs/tags/v${MY_PV}.tar.gz -> ${MY_P}.tar.gz"

LICENSE="ngrep"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~arm ~hppa ~ppc ~ppc64 ~s390 ~sparc ~x86 ~amd64-linux ~x86-linux ~ppc-macos"
IUSE="ipv6"

DEPEND="
	dev-libs/libpcre2
	net-libs/libpcap
"

RDEPEND="
	${DEPEND}
	acct-group/ngrep
	acct-user/ngrep
"

src_prepare() {
	default

	sed -i -e "s:configure.in:configure.ac:" regex*/{configure.in,Makefile.in} || die

	eautoreconf
}

src_configure() {
	local myeconfargs=(
		$(use_enable ipv6)
		--disable-pcap-restart
		--enable-pcre2
		--with-dropprivs-user=ngrep
	)

	econf "${myeconfargs[@]}"
}

src_compile() {
	emake STRIPFLAG="${CFLAGS}"
}

src_install() {
	emake STRIP=true DESTDIR="${D}" install

	local DOCS=( CREDITS EXAMPLES.md README.md )
	einstalldocs
}
