# Copyright 1999-2021 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DESCRIPTION="a small getty for virtual consoles"
HOMEPAGE="http://www.fefe.de/fgetty/"
SRC_URI="http://www.fefe.de/fgetty/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"

PATCHES=(
	"${FILESDIR}/${PN}-0.7-Makefile.patch"
	"${FILESDIR}/${PN}-0.7-build_fixes.patch"
)

src_compile() {
	emake DIET= STRIP= CFLAGS="${CFLAGS}" LDFLAGS="${LDFLAGS}" \
		MANDIR="${EPREFIX}/usr/share/man" fgetty
}

src_install() {
    exeinto /sbin
    doexe ${PN}
    doman ${PN}.8
    dodoc README CHANGES
}
