# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI='8'

MY_PV="${PV:0:4}-${PV:4:2}-${PV:6:2}"

DESCRIPTION="The DNSSEC root key(s)"
HOMEPAGE="https://www.iana.org/dnssec/"

RA_BASE_URI="https://data.iana.org/root-anchors/old/${MY_PV}"
SRC_URI="
	${RA_BASE_URI}/root-anchors.xml -> root-anchors-${PV}.xml
	${RA_BASE_URI}/root-anchors.p7s -> root-anchors-${PV}.p7s
	${RA_BASE_URI}/icannbundle.pem -> icannbundle-${PV}.pem
"

LICENSE="public-domain"
SLOT="0"
KEYWORDS="~alpha amd64 arm arm64 ~hppa ~loong ~mips ppc ppc64 ~riscv ~s390 ~sparc x86 ~x64-macos"
IUSE=""

BDEPEND="dev-libs/libxml2"
DEPEND=""

src_unpack() {
	mkdir "${S}" || die

	cp -t "${S}" "${DISTDIR}"/root-anchors-${PV}.{p7s,xml} "${DISTDIR}"/icannbundle-${PV}.pem || die
}

src_prepare() {
	mv root-anchors-${PV}.xml root-anchors.xml || die
	mv root-anchors-${PV}.p7s root-anchors.p7s || die
	mv icannbundle-${PV}.pem icannbundle.pem || die

	if has_version "dev-libs/openssl" ; then
		# Signature validating is optional:
		#   - We are already downloading SRC, signature file & CA from same URI
		#   - We store checksums for distfiles
		einfo "dev-libs/openssl is available, will validate signature of root-anchors.xml"
		openssl smime -verify \
			-content root-anchors.xml \
			-in root-anchors.p7s -inform der \
			-CAfile icannbundle.pem \
			-noverify || die "OpenSSL S/Mime verify failed"
	else
		einfo "dev-libs/openssl is not available, skipping optional validation root-anchors.xml"
	fi

	default
}

src_compile() {
	local KEYTAG="" ALGORITHM="" DIGESTTYPE="" DIGEST="" key_id
	local xml="root-anchors.xml"

	for key_id in $(xmllint --xpath "/TrustAnchor/KeyDigest/@id" "${xml}") ; do
		KEYTAG="$(xmllint --xpath "/TrustAnchor/KeyDigest[@${key_id}]/KeyTag/node()" "${xml}")"
		ALGORITHM="$(xmllint --xpath "/TrustAnchor/KeyDigest[@${key_id}]/Algorithm/node()" "${xml}")"
		DIGESTTYPE="$(xmllint --xpath "/TrustAnchor/KeyDigest[@${key_id}]/DigestType/node()" "${xml}")"
		DIGEST="$(xmllint --xpath "/TrustAnchor/KeyDigest[@${key_id}]/Digest/node()" "${xml}")"
		echo ". IN DS ${KEYTAG} ${ALGORITHM} ${DIGESTTYPE} ${DIGEST}" >> root-anchors.txt
	done

	if [[ ! -s "root-anchors.txt" ]] ; then
		die "Sanity check failed: root-anchors.txt is empty or does not exist!"
	fi
}

src_install() {
	insinto /etc/dnssec
	doins root-anchors.{p7s,txt,xml} icannbundle.pem
}
