# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8
inherit autotools systemd

DESCRIPTION="Opensource alternative to shoutcast that supports mp3, ogg and aac streaming"
HOMEPAGE="http://www.icecast.org/"
case "${PV}" in
	(*_rc*)
		MY_P="${PN}-$(ver_cut 1).$(($(ver_cut 2) - 1)).999.$(ver_cut 5)"
	;;
	(*)
		MY_P="${P}"
	;;
esac
SRC_URI="http://downloads.xiph.org/releases/icecast/${MY_P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~ppc ~ppc64 ~x86 ~x86-fbsd"
IUSE="ipv6 logrotate selinux +speex +ssl +theora +yp"

#Although there is a --with-ogg and --with-orbis configure option, they're
#only useful for specifying paths, not for disabling.
DEPEND="
	acct-group/icecast
	acct-user/icecast
	dev-libs/libigloo
	dev-libs/libxml2:=
	dev-libs/libxslt
	media-libs/libogg
	media-libs/libvorbis
	logrotate? ( app-admin/logrotate )
	speex? ( media-libs/speex )
	ssl? ( dev-libs/openssl:0= )
	theora? ( media-libs/libtheora:= )
	yp? ( net-misc/curl )
"
RDEPEND="
	${DEPEND}
	selinux? ( sec-policy/selinux-icecast )
"

S="${WORKDIR}/${MY_P}"

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	local myeconfargs=(
		--disable-dependency-tracking
		--docdir=/usr/share/doc/${PF}
		--sysconfdir=/etc/icecast2
		$(use_enable ipv6)
		$(use_enable yp)
		$(use_with speex)
		$(use_with ssl openssl)
		$(use_with theora)
		$(use_with yp curl)
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	local DOCS=( AUTHORS README.md HACKING NEWS conf/icecast.xml.dist )
	default

	docinto html
	dodoc doc/*.html

	newinitd "${FILESDIR}"/${PN}.initd ${PN}
	systemd_dounit "${FILESDIR}"/${PN}.service

	insinto /etc/icecast2
	doins "${FILESDIR}"/icecast.xml
	fperms 600 /etc/icecast2/icecast.xml

	if use logrotate; then
		dodir /etc/logrotate.d
		insopts -m0644
		insinto /etc/logrotate.d
		newins "${FILESDIR}"/${PN}.logrotate ${PN}
	fi

	diropts -m0764 -o icecast -g icecast
	dodir /var/log/icecast
	keepdir /var/log/icecast
	rm -r "${ED}"/usr/share/doc/icecast || die
}

pkg_postinst() {
	touch "${ROOT}"/var/log/icecast/{access,error}.log
	chown icecast:icecast "${ROOT}"/var/log/icecast/{access,error}.log
}
