# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit ecm

MY_P="${PN}_${PV}"

DESCRIPTION="Visual client for UPS systems"
HOMEPAGE="https://sites.google.com/a/prynych.cz/knutclient/"
SRC_URI="https://www.gentoofan.org/files/${MY_P}.tar.gz"
LICENSE="GPL-2"
SLOT="0"

KEYWORDS="~amd64 ~x86"
IUSE=""

RDEPEND="
	dev-qt/qtgui:5
	dev-qt/qtnetwork:5
	dev-qt/qtwidgets:5
	kde-frameworks/kcompletion:5
	kde-frameworks/kconfig:5
	kde-frameworks/kconfigwidgets:5
	kde-frameworks/kcoreaddons:5
	kde-frameworks/ki18n:5
	kde-frameworks/kiconthemes:5
	kde-frameworks/knotifications:5
	kde-frameworks/kwidgetsaddons:5
	kde-frameworks/kwindowsystem:5
	kde-frameworks/kxmlgui:5
"
DEPEND="${RDEPEND}"

S="${WORKDIR}/${MY_P}"

PATCHES=( "${FILESDIR}/${PN}-1.0.5-desktop.patch" )

src_prepare() {
	# cs translation is broken at least since kde gear 24.12
	sed -i '/(cs)/d' doc/CMakeLists.txt || die

	ecm_src_prepare
}
