# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools pam

DESCRIPTION="NFC-based PAM authentication module"
HOMEPAGE="https://github.com/nfc-tools/pam_nfc"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/nfc-tools/pam_nfc.git"
else
	SRC_URI=""
	KEYWORDS="~amd64 ~x86"
fi
LICENSE="GPL-2"
SLOT="0"

IUSE="debug"

RDEPEND="
	dev-libs/libnfc
	dev-libs/libusb-compat
	sys-libs/pam
	virtual/libcrypt
"
DEPEND="${RDEPEND}"

BDEPEND="virtual/pkgconfig"

src_prepare() {
	default

	sed -i 's@\(bin_PROGRAMS\)@s\1@' Makefile.am || die

	eautoreconf
}

src_configure() {
	local myeconfargs=(
		$(use_enable debug)
		--with-pam-dir="$(getpam_mod_dir)"
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	default

	find "${ED}" -type f -name "*.la" -delete || die
}
