# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 21c147ceab1d74be5516d1098776235fa62d51a7 $

EAPI=8

inherit linux-mod-r1

SDIR="sp143001-143500"
TARBALL="sp143035.tgz"
HPFLASH_DIR="hpflash-3.22"

DESCRIPTION="Kernel driver for HP Linux UEFI BIOS utilities"
HOMEPAGE="https://ftp.hp.com/pub/caps-softpaq/cmit/linuxtools/HP_LinuxTools.html"
SRC_URI="https://ftp.hp.com/pub/softpaq/${SDIR}/${TARBALL}"
LICENSE="GPL-2"
SLOT="0"

KEYWORDS="~amd64"
IUSE=""

src_unpack() {
	unpack ${A}
	unpack ${HPFLASH_DIR}/non-rpms/${P}.tgz
}

src_prepare() {
	default

	if kernel_is -ge 6 3 ; then
		eapply "${FILESDIR}"/${PN}-3.04-kernel-6.3.patch
	fi

	# Use /usr/src/linux for the kernel target
	sed -i \
		-e '/^KSRC/s@/lib/modules/$(KVERS)/build@/usr/src/linux@' \
		Makefile || die
	sed -i \
		-e '1i#!/bin/sh' \
		mkdevhpuefi || die
}

src_compile() {
	local modlist=( ${PN/-*}=kernel/drivers/${PN/-*} )
	linux-mod-r1_src_compile
}

src_install() {
	linux-mod-r1_src_install

	exeinto /opt/hp/hp-flash
	doexe mkdevhpuefi
}
