# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit webapp

DESCRIPTION="Blog software written in php"
HOMEPAGE="https://docs.s9y.org/"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI=""
else
	SRC_URI="https://github.com/s9y/${PN^}/releases/download/${PV}/${P}.zip"
	KEYWORDS="~amd64"
fi
LICENSE=""

IUSE=""

DEPEND="app-arch/unzip"
RDEPEND="
	>=dev-lang/php-8
	virtual/httpd-php
	virtual/mysql
"

S="${WORKDIR}/${PN}"

#fix_permissions() {
#}

src_install() {
	webapp_src_preinst

	insinto "${MY_HTDOCSDIR}"
	doins -r .

	webapp_src_install

#	if has_version www-server/apache ; then
#	elif has_version www-servers/nginx ; then
#	else
#		einfo "Some permissions might need manual adjustment."
#	fi
}
