# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 7b7ecc39822eefff651d86cd2fcc1528a43ef96d $

EAPI=7

inherit desktop xdg

DESCRIPTION="Tk based dictionary (German-English) (incl. dictionary itself)"
HOMEPAGE="https://www-user.tu-chemnitz.de/~fri/ding/"
SRC_URI="http://wftp.tu-chemnitz.de/pub/Local/urz/ding/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ~ppc ~sparc x86"
IUSE=""

RDEPEND=">=dev-lang/tk-8.3"

PATCHES=(
	"${FILESDIR}/${PN}-1.9-deprecate_egrep.patch"
)

src_install() {
	dobin ding
	insinto /usr/share/dict
	doins de-en.txt
	doman ding.1
	dodoc CHANGES README.md

	doicon ding.png
	domenu ding.desktop
}
