# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="Medical Image Conversion Utility"
HOMEPAGE="http://xmedcon.sourceforge.net"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.bz2"

LICENSE="GPL-2 LGPL-2"
SLOT="0"
KEYWORDS="~amd64"
IUSE="png gui"

RDEPEND="
	dev-libs/glib:2
	virtual/zlib
        gui? (
		app-accessibility/at-spi2-core:2
		media-libs/harfbuzz
	        x11-libs/cairo
	        >=x11-libs/gdk-pixbuf-2.36.0
    		>=x11-libs/gtk+-3.22.0
    		x11-libs/pango
    	)
        png? ( >=media-libs/libpng-1.2.1 )
"
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

PATCHES=(
	"${FILESDIR}"/${PN}-0.25.1-gentoo.patch
)

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	local myeconfargs=(
		$(use_enable gui)
		$(use_enable png)
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	local DOCS=( AUTHORS COPYING* INSTALL NEWS README REMARKS )

	default
	einstalldocs

	find "${ED}" -type f -name "*.la" -delete || die
}
