# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id$

EAPI=8

DESCRIPTION="cutmp3 is a small and fast command line MP3 editor."
HOMEPAGE="https://github.com/tarjanm-movidius/cutmp3"
SRC_URI="https://github.com/tarjanm-movidius/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="kde"
RDEPEND="sys-libs/readline:0=
	sys-libs/ncurses:0=
	media-sound/mpg123"
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

PATCHES=( "${FILESDIR}"/${PN}-4.0-gentoo.patch )

src_install() {
	emake PREFIX="${D}/usr" DOCDIR="${D}/usr/share/doc/${PF}" install
	if use kde ; then
		insinto /usr/share/apps/konqueror/servicemenus
		doins ${PN}.desktop
	fi
}
