# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit linux-mod-r1

DESCRIPTION="Embedded Controller for MSI laptops"
HOMEPAGE="https://github.com/BeardOverflow/msi-ec"
if [[ "${PV}" == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/BeardOverflow/${PN}.git"
else
	SRC_URI=""
	KEYWORDS="~amd64"
fi
LICENSE="GPL-2+"
SLOT="0"

IUSE=""

pkg_setup() {
	CONFIG_CHECK="ACPI ACPI_BATTERY"

	if kernel_is -ge 6 4 ; then
		CONFIG_CHECK+=" !MSI_EC"
	fi

	check_extra_config
	linux-mod-r1_pkg_setup
}

src_prepare() {
	default

	if kernel_is -lt 6 2 ; then
		eapply "${S}"/older-kernel.patch
	fi
}

src_compile() {
	local modlist=( ${PN} )

	KERNELRELEASE="$(grep -o '[[:digit:]\.]\+' <<< $(basename $(readlink -f /usr/src/linux)))"
	if [[ "$(tr '.' ' ' <<< ${KERNELRELEASE} | wc -w)" -eq 2 ]] ; then
		KERNELRELEASE="${KERNELRELEASE}.0"
	fi
	[[ -d /lib/modules/${KERNELRELEASE}/build ]] && export KERNELRELEASE

	linux-mod-r1_src_compile
}
