# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: f174dd82b831e0bf0cacefe0f1bd2e6993ab11d1 $

EAPI=8

VERIFY_SIG_OPENPGP_KEY_PATH=/usr/share/openpgp-keys/gzip.asc
inherit eapi9-ver flag-o-matic verify-sig

DESCRIPTION="Standard GNU compressor"
HOMEPAGE="https://www.gnu.org/software/gzip/"
if [[ ${PV} == *_p* ]] ; then
	# Note: could put this in devspace, but if it's gone, we don't want
	# it in tree anyway. It's just for testing.
	MY_SNAPSHOT="$(ver_cut 1-2).31-7553"
	SRC_URI="
		https://meyering.net/gzip/gzip-${MY_SNAPSHOT}.tar.xz -> ${P}.tar.xz
		verify-sig? (
			https://meyering.net/gzip/gzip-${MY_SNAPSHOT}.tar.xz.sig -> ${P}.tar.xz.sig
		)
	"
	S="${WORKDIR}"/${PN}-${MY_SNAPSHOT}
else
	SRC_URI="
		mirror://gnu/gzip/${P}.tar.xz
		verify-sig? (
			mirror://gnu/gzip/${P}.tar.xz.sig
		)
	"
fi

LICENSE="GPL-3+"
SLOT="0"
if [[ ${PV} != *_p* ]] ; then
	KEYWORDS="~alpha amd64 arm arm64 ~hppa ~loong ~m68k ~mips ppc ppc64 ~riscv ~s390 ~sparc x86 ~arm64-macos ~x64-macos ~x64-solaris"
fi
IUSE="pic static"

BDEPEND="verify-sig? ( sec-keys/openpgp-keys-gzip )"
RDEPEND="!<app-alternatives/gzip-99
	!app-arch/pigz[symlink(-)]"

PATCHES=(
	"${FILESDIR}/${PN}-1.3.8-install-symlinks.patch"
)

src_configure() {
	use static && append-flags -static

	# Avoid text relocation in gzip
	use pic && export DEFS="NO_ASM"

	# embeds the path to grep detected at build time into installed scripts;
	# use the canonical USE="split-usr" agnostic path. bug #935721
	export GREP="${EPREFIX}/bin/grep"

	# bug #663928
	econf --disable-gcc-warnings
}

src_install() {
	default

	docinto txt
	dodoc algorithm.doc gzip.doc

	# Avoid conflict with app-arch/ncompress
	rm "${ED}"/usr/bin/uncompress || die

	# keep most things in /usr, just the fun stuff in /
	dodir /bin
	mv "${ED}"/usr/bin/{gunzip,gzip,zcat} "${ED}"/bin/ || die
	sed -e "s:${EPREFIX}/usr:${EPREFIX}:" -i "${ED}"/bin/gunzip || die
}

pkg_postinst() {
	if ver_replacing -lt "1.12-r2"; then
		ewarn "This package no longer installs 'uncompress'."
		ewarn "Please use 'gzip -d' to decompress .Z files."
	fi
}
