# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 1959db4febaebe40f8cbd1fcb6a54c5cd7471ba0 $

EAPI=8

VERIFY_SIG_OPENPGP_KEY_PATH=/usr/share/openpgp-keys/tar.asc
inherit branding multiprocessing verify-sig

DESCRIPTION="Use this to make tarballs :)"
HOMEPAGE="https://www.gnu.org/software/tar/"
SRC_URI="
	mirror://gnu/tar/${P}.tar.xz
	https://alpha.gnu.org/gnu/tar/${P}.tar.xz
	verify-sig? (
		mirror://gnu/tar/${P}.tar.xz.sig
		https://alpha.gnu.org/gnu/tar/${P}.tar.xz.sig
	)
"

LICENSE="GPL-3+"
SLOT="0"
if [[ -z "$(ver_cut 3)" ]] || [[ "$(ver_cut 3)" -lt 90 ]] ; then
	KEYWORDS="~alpha amd64 arm arm64 ~hppa ~loong ~m68k ~mips ppc ppc64 ~riscv ~s390 ~sparc x86 ~arm64-macos ~x64-macos ~x64-solaris"
fi
IUSE="acl minimal nls selinux xattr"

RDEPEND="
	!<app-alternatives/tar-99
	acl? ( virtual/acl )
	selinux? ( sys-libs/libselinux )
"
DEPEND="
	${RDEPEND}
	xattr? ( elibc_glibc? ( sys-apps/attr ) )
"
BDEPEND="
	nls? ( sys-devel/gettext )
	verify-sig? ( sec-keys/openpgp-keys-tar )
"

src_configure() {
	# -fanalyzer doesn't make sense for us in ebuilds, as it's for static analysis
	export gl_cv_warn_c__fanalyzer=no

	local myeconfargs=(
		--bindir="${EPREFIX}"/bin
		# Avoid -Werror
		--disable-gcc-warnings
		--enable-backup-scripts
		--libexecdir="${EPREFIX}"/usr/sbin
		$(use_with acl posix-acls)
		$(use_enable nls)
		$(use_with selinux)
		$(use_with xattr xattrs)
	)

	# Drop CONFIG_SHELL hack after 1.35: https://git.savannah.gnu.org/cgit/tar.git/commit/?id=7687bf4acc4dc4554538389383d7fb4c3e6521cd
	CONFIG_SHELL="${BROOT}"/bin/bash FORCE_UNSAFE_CONFIGURE=1 econf "${myeconfargs[@]}"
}

src_test() {
	# Drop after 1.35: https://git.savannah.gnu.org/cgit/tar.git/commit/?id=18f90676e4695ffcf13413e9fbb24cc0ae2ae9d5
	local -x XZ_OPT= XZ_DEFAULTS=

	emake check TESTSUITEFLAGS="--jobs=$(get_makeopts_jobs)"
}

src_install() {
	default

	# A nasty yet required piece of baggage
	exeinto /etc
	doexe "${FILESDIR}"/rmt

	# autoconf looks for gtar before tar (in configure scripts), hence
	# in Prefix it is important that it is there, otherwise, a gtar from
	# the host system (FreeBSD, Solaris, Darwin) will be found instead
	# of the Prefix provided (GNU) tar
	#if use prefix ; then
		dosym tar /bin/gtar
	#fi

	mv "${ED}"/usr/sbin/backup{,-tar} || die
	mv "${ED}"/usr/sbin/restore{,-tar} || die

	if use minimal ; then
		find "${ED}"/etc "${ED}"/*bin/ "${ED}"/usr/*bin/ \
			-type f -a '!' -name tar \
			-delete || die
	fi
}
