# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

CMAKE_MAKEFILE_GENERATOR="emake"

inherit cmake desktop

DESCRIPTION="a World War II German submarine simulation"
HOMEPAGE="http://dangerdeep.sourceforge.net/"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://git.code.sf.net/p/dangerdeep/git/"
	S="${WORKDIR}/${P}/${PN}"
else
	SRC_URI=""
	KEYWORDS="~amd64 ~x86"
fi
LICENSE="GPL-2 CC-BY-NC-ND-2.0"
SLOT="0"

IUSE=""

RDEPEND="
	app-arch/bzip2
	media-libs/libglvnd
	media-libs/libsdl2
	media-libs/sdl2-image
	media-libs/sdl2-mixer
	sci-libs/fftw:3.0
	virtual/glu
"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}"/${PN}-0.4.0-dev-missing_includes.patch
)

src_configure() {
	local mycamkeargs=(
		-DDFTD_COLOR_MAKEFILE=ON
		-DDFTD_DATADIR="/usr/share/${PN}/data"
		-DDFTD_VERBOSE=OFF
	)
	cmake_src_configure
}

src_install() {
	dobin "${BUILD_DIR}"/src/${PN}

	insinto /usr/share/${PN}
	doins -r data

	doman doc/man/${PN}.6
	newicon packaging/dftd_icon.png ${PN}.png

	make_desktop_entry ${PN} "Danger from the Deep" ${PN}.png

	local DOCS=(
		doc/manual/${PN}_manual.pdf
	)
	einstalldocs
}
