# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: d3642c83ba3b66e107a397b12cc0ed8ff687a2f0 $

EAPI=8

QTMIN=6.10.1
inherit ecm frameworks.kde.org

DESCRIPTION="Framework for network service discovery using Zeroconf"

LICENSE="LGPL-2+"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~x86"
IUSE="zeroconf"

DEPEND="
	>=dev-qt/qtbase-${QTMIN}:6[network]
	zeroconf? (
		>=dev-qt/qtbase-${QTMIN}:6[dbus]
		net-dns/avahi[mdnsresponder-compat]
	)
"
RDEPEND="${DEPEND}"
BDEPEND=">=dev-qt/qttools-${QTMIN}:6[linguist]"

src_configure() {
	local mycmakeargs=(
		$(cmake_use_find_package zeroconf Avahi)
	)
	use zeroconf || mycmakeargs+=( -DCMAKE_DISABLE_FIND_PACKAGE_DNSSD=ON )

	ecm_src_configure
}
