# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit cmake-multilib poly-c_ebuilds

REAL_PN="${PN/sdl3-/SDL3_}"
REAL_P="${REAL_PN}-${MY_PV}"
DESCRIPTION="Graphics drawing primitives library for SDL3"
HOMEPAGE="https://github.com/sabdul-khabir/SDL3_gfx"
SRC_URI="https://github.com/sabdul-khabir/${REAL_PN}/archive/refs/tags/v${MY_PV}.tar.gz -> ${MY_P}.tar.gz"
S="${WORKDIR}/${REAL_P}"

LICENSE="ZLIB"
SLOT="0"
KEYWORDS="~amd64 ~ppc ~ppc64 ~x86"
IUSE="doc cpu_flags_x86_mmx"

DEPEND="media-libs/libsdl3[${MULTILIB_USEDEP}]"
RDEPEND="${DEPEND}"

DOCS=( AUTHORS ChangeLog NEWS README.md )

multilib_src_install_all() {
	einstalldocs

	if use doc ; then
		docinto html
		dodoc -r Docs/html/*
	fi
}
