# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 4b71210c33ab60a700a2b8cb863208a88b641e9a $

EAPI=7

inherit multilib-minimal

DESCRIPTION="Common configurations for all packages in suitesparse"
HOMEPAGE="https://people.engr.tamu.edu/davis/suitesparse.html"
SRC_URI="http://202.36.178.9/sage/${P}.tar.bz2"

# Upstream says, "no licensing restrictions apply to this file or to the
# SuiteSparse_config directory".
LICENSE="public-domain"
SLOT="0"
KEYWORDS="~alpha amd64 arm arm64 ~hppa ~loong ~mips ppc ppc64 ~riscv ~s390 ~sparc x86 ~arm64-macos ~x64-macos"
IUSE="static-libs"

multilib_src_configure() {
	ECONF_SOURCE="${S}" \
		econf \
		$(use_enable static-libs static)
}

multilib_src_install_all() {
	if ! use static-libs; then
		find "${ED}" -name "*.la" -delete || die
	fi
}
