# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit systemd toolchain-funcs

DESCRIPTION="Firmware loader for Renesas uPD72020x USB 3.0 chipsets"
HOMEPAGE="https://github.com/markusj/upd72020x-load"
if [[ "${PV}" == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/markusj/upd72020x-load.git"
else
	SRC_URI=""
	KEYWORDS="~amd64 ~x86"
fi
LICENSE=""
SLOT="0"

IUSE=""

src_compile() {
	tc-export CC
	default
}

src_install() {
	dosbin ${PN} upd72020x-check-and-init
	systemd_dounit systemd/upd72020x-fwload.service
}
