# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools pam

DESCRIPTION="PAM module implementing authentication via OpenPGP smartcards"
HOMEPAGE="http://www.gnupg.org/"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://git.gnupg.org/poldi.git"
else
	SRC_URI="ftp://ftp.gnupg.org/gcrypt/alpha/poldi/${P}.tar.bz2"
	KEYWORDS="~amd64 ~x86"
fi
LICENSE="GPL-2"
SLOT="0"
IUSE="usb"

DEPEND="
	dev-libs/libgcrypt
	>=dev-libs/libgpg-error-0.7
	virtual/pam
	usb? ( >=dev-libs/libusb-0.1.10a )
"
RDEPEND="${DEPEND}"

PATCHES=(
	"${FILESDIR}"/${P}-debian.patch
	"${FILESDIR}"/${P}-ldflags.patch
)

src_prepare() {
	default
	eautoreconf
}

src_install() {
	default

	dopammod src/pam/pam_poldi.so
	#ChangeLog and INSTALL are not useful
	dodoc AUTHORS NEWS README THANKS
	insinto /etc/poldi
	doins "${FILESDIR}"/poldi.conf.example
}
