# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 21c147ceab1d74be5516d1098776235fa62d51a7 $

EAPI=8

MODULES_EXTRA_EMAKE="KCFLAGS=-Wno-incompatible-pointer-types"
inherit linux-mod-r1

SDIR='sp157501-158000'
TARBALL='sp157762.tgz'

DESCRIPTION="Kernel driver for HP Linux UEFI BIOS utilities"
HOMEPAGE="https://ftp.hp.com/pub/caps-softpaq/cmit/linuxtools/HP_LinuxTools.html"
SRC_URI="https://ftp.hp.com/pub/softpaq/${SDIR}/${TARBALL}"
LICENSE="GPL-2"
SLOT="0"

KEYWORDS="~amd64"
IUSE=""

src_unpack() {
	unpack ${A}
	unpack non-rpms/${P}.tgz
}

src_prepare() {
	default

	# Use /usr/src/linux for the kernel target
	sed -i \
		-e '/^KSRC/s@/lib/modules/$(KVERS)/build@/usr/src/linux@' \
		Makefile || die
	sed -i \
		-e '1i#!/bin/sh' \
		mkdevhpuefi || die
}

src_compile() {
	local modlist=( ${PN/-*}=kernel/drivers/${PN/-*} )
	linux-mod-r1_src_compile
}

src_install() {
	linux-mod-r1_src_install

	exeinto /opt/hp/hp-flash
	doexe mkdevhpuefi
}
