# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2
# $Id: 03b5608d673637332ca574e4e96a71f0a122a71e $

EAPI=8

inherit flag-o-matic

DESCRIPTION="simple TUI display manager"
HOMEPAGE=""
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/javalsai/lidm.git"
else
	SRC_URI="https://github.com/javalsai/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64"
fi
LICENSE=""
SLOT="0"

IUSE="X local +wayland"

src_prepare() {
	default

	sed -i '3i SHELL := bash -O extglob' Makefile || die
	sed -i \
		-e '/openrc-run/s@/usr/bin@/sbin@' \
		-e 's@ /bin/lidm@ /usr/bin/lidm@' \
		assets/services/openrc || die
}

src_compile() {
	if ! use X ; then
		append-cppflags -DSESSIONS_XSESSIONS=\\\"/var/empty\\\"
	fi
	if ! use wayland ; then
		append-cppflags -DSESSIONS_WAYLAND=\\\"/var/empty\\\"
	fi
	if ! use local || ! use X ; then
		append-cppflags -DSESSIONS_XSESSIONS_LOCAL=\\\"/var/empty\\\"
	fi
	if ! use local || ! use wayland ; then
		append-cppflags -DSESSIONS_WAYLAND_LOCAL=\\\"/var/empty\\\"
	fi

	emake PREFIX='/usr'
}

src_install() {
	emake DESTDIR="${D}" PREFIX='/usr' install

	newinitd assets/services/openrc ${PN}
}
